; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.

[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;
[Command]
name = "cpu1"
command = ~U, D, F, B, x
time = 1

[Command]
name = "cpu2"
command = ~U, D, F, B, y
time = 1

[Command]
name = "cpu3"
command = ~U, D, F, B, z
time = 1

[Command]
name = "cpu4"
command = ~U, D, F, s
time = 1

[Command]
name = "cpu5"
command = ~U, D, F, a
time = 1

[Command]
name = "cpu6"
command = ~U, D, F, b
time = 1

[Command]
name = "cpu7"
command = ~U, D, F, c
time = 1

[Command]
name = "cpu8"
command = ~U, D, F, x
time = 1

[Command]
name = "cpu9"
command = ~U, D, F, y
time = 1

[Command]
name = "cpu10"
command = ~U, D, F, z
time = 1

[Command]
name = "cpu11"
command = ~F, F, a, x
time = 0

[Command]
name = "cpu12"
command = ~B, B, U, a
time = 0

[Command]
name = "cpu13"
command = ~U, D, a, B, z
time = 1

[Command]
name = "cpu14"
command = ~U, D, F, F
time = 1

[Command]
name = "cpu15"
command = ~U, U, F, U
time = 1

[Command]
name = "cpu16"
command = ~U, D, D, D
time = 1

[Command]
name = "cpu17"
command = ~U, c, c, F
time = 1

[Command]
name = "cpu18"
command = ~U, b, F, x
time = 1

[Command]
name = "TripleKFPalm"
command = ~D, DF, F, D, DF, F, x
time = 20

[Command]
name = "]"
command = ~D, DF, F, D, DF, F, y
time = 30

[Command]
name = "SmashKFUpper"
command = ~D, DB, B, D, DB, B, x;~F, D, DF, F, D, DF, x
time = 20

[Command]
name = "SmashKFUpper"   ;Same name as above
command = ~D, DB, B, D, DB, B, y;~F, D, DF, F, D, DF, y
time = 20

[Command]
name = "_"
command = ~D, DB, B, DB, D, DF, F, b
time = 30
;-| Special Motions |------------------------------------------------------
[Command]
name = "upper_x"
command = ~F, D, DF, x

[Command]
name = "upper_y"
command = ~F, D, DF, y

[Command]
name = "upper_z"
command = ~F, D, DF, z

[Command]
name = "upper_xy"
command = ~F, D, DF, x+y

[Command]
name = "QCF_x"
command = ~D, DF, F, x

[Command]
name = "QCF_y"
command = ~D, DF, F, y

[Command]
name = "QCF_z"
command = ~D, DF, F, z

[Command]
name = "QCF_xy"
command = ~D, DF, F, x+y

[Command]
name = "QCF_a"
command = ~D, DF, F, a

[Command]
name = "QCB_x"
command = ~D, DB, B, x

[Command]
name = "QCB_y"
command = ~D, DB, B, y

[Command]
name = "QCB_z"
command = ~D, DB, B, z

[Command]
name = "QCB_a"
command = ~D, DB, B, a

[Command]
name = "QCB_xy"
command = ~D, DB, B, x+y

[Command]
name = "FF_ab"
command = F, F, a+b

[Command]
name = "FF_a"
command = F, F, a

[Command]
name = "FF_b"
command = F, F, b

[Command]
name = "ax"
command = a+x
time = 1

[Command]
name = "ay"
command = a+y
time = 1

[Command]
name = "az"
command = a+z
time = 1

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "xyz"
command = x+y+z
time = 1

[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = b
time = 1

[Command]
name = "sw"
command = a+b
time = 1

[Command]
name = "tyou"
command = x+a
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "low"
command = /DF,b
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "DU"
command = $D, $U
time = 15

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdf"
command = /F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holdx"
command = /x
time = 1

[Command]
name = "holdy"
command = /y
time = 1

[Command]
name = "holdz"
command = /z
time = 1

[Command]
name = "holdb"
command = /b
time = 1

;------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;========================================================================
;Super Combo
;------------------------------------------------------------------------
;a
[State -1]
type = ChangeState
value = 3000
triggerall = command = "QCF_xy" && var(3) = 0
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 5201

;؎a
[State -1]
type = ChangeState
value = 2500
triggerall = command = "QCF_xy" && var(3) = 1
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno != [226,228]) && stateno != 240 && stateno != 250 && stateno != 416 && stateno = [205,425]
trigger2 = movecontact
trigger3 = stateno = 5201

[State -3]
type = ChangeState
value = 3100
triggerall = numhelper(2) = 0
triggerall = command = "QCB_xy" && var(3) = 1
triggerall = power >= 2000
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno != [226,228]) && stateno != 240 && stateno != 250 && stateno != 416 && stateno = [205,425]
trigger2 = movecontact
trigger3 = numhelper(1) = 1 && (stateno != [729,732]) && stateno != 721 && stateno = [720,733]
trigger3 = movecontact
trigger4 = stateno = 5201

;------------------------------------------------------------------------
;tandem
[State -1]
type = ChangeState
value = 710
triggerall = command = "QCB_a" && power >= 1000 && statetype != A
trigger1 = ctrl
trigger2 = stateno = [200,430]
trigger3 = stateno = 5201

;========================================================================
;K[hLZ
[State -1]
type = ChangeState
value = 265
trigger1 = command = "upper_x" || command = "upper_y" || command = "upper_z"
trigger1 = var(3) = 0 && stateno = [150,153]
;trigger2 = command = "c" && statetype != A && var(3) = 0 && ctrl

[State -1]
type = ChangeState
value = 1010
triggerall = command = "upper_x" || command = "upper_y" || command = "upper_z"
trigger1 = var(3) = 1 && stateno = [150,153]

;------------------------------------------------------------------------
;coԂ
[State -1]
type = ChangeState
value = 1100-358*(numhelper(1) = 1)
triggerall = (command = "upper_x" || command = "upper_y" || command = "upper_z") && var(3) = 1
trigger1 = statetype != A && ctrl
trigger2 = (stateno != [226,228]) && stateno != 240 && stateno != 250 && stateno != 416 && stateno = [205,425]
trigger2 = movecontact
trigger3 = numhelper(1) = 1 && (stateno != [729,732]) && stateno != 721 && stateno = [720,733]
trigger3 = movecontact
trigger4 = stateno = 5201

;------------------------------------------------------------------------
;SAa
[State -1]
type = ChangeState
value = 1000-265*(numhelper(1) = 1)
triggerall = var(3) = 1
triggerall = command = "QCF_x" || command = "QCF_y" || command = "QCF_z"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno != [226,228]) && stateno != 240 && stateno != 250 && stateno != 260 && stateno != 416 && stateno = [205,425]
trigger2 = movecontact
trigger3 = numhelper(1) = 1 && (stateno != [729,732]) && stateno != 721 && stateno = [720,733]
trigger3 = movecontact
trigger4 = stateno = 5201

;------------------------------------------------------------------------
;
[State -1]
type = ChangeState
value = 1200
triggerall = var(3) = 1
triggerall = command = "QCB_x" || command = "QCB_y" || command = "QCB_z" || command = "c"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno != [226,228]) && stateno != 240 && stateno != 250 && stateno != 260 && stateno != 416 && stateno = [205,425]
trigger2 = movecontact
trigger3 = numhelper(1) = 1 && (stateno != [729,732]) && stateno != 721 && stateno = [720,733]
trigger3 = movecontact
trigger4 = stateno = 5201

;------------------------------------------------------------------------
;GXP[v_bV
[State -1]
type = ChangeState
value = 118
triggerall = command = "xyz" && var(3) = 0
trigger1 = ctrl && statetype != A

;------------------------------------------------------------------------
;X^hoU
[State -1]
type = ChangeState
value = 260
triggerall = command = "QCF_a" && var(3) = 0 && statetype != A
trigger1 = ctrl
trigger2 = movecontact && stateno = [200,420]

;------------------------------------------------------------------------
;Taunt
;
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl
;========================================================================
;Run Fwd
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = command = "FF" && statetype = S
trigger1 = ctrl

;------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = command = "BB" && statetype = S
trigger1 = ctrl

;------------------------------------------------------------------------
;advancing guard
[State -1]
type = ChangeState
value = 700
trigger1 = command = "xyz"
trigger1 = stateno = [150,153]
;------------------------------------------------------------------------
;Stand On
[State -1]
type = ChangeState
value = 111
triggerall = statetype = S && command != "holddown"
triggerall = ctrl && var(3) = 0
trigger1 =  command = "a" || command = "ax" || command = "ay" || command = "az"

[State -1]
type = ChangeState
value = 112
triggerall = statetype = S && command != "holddown"
triggerall = ctrl && var(3) = 1
trigger1 =  command = "a"
;------------------------------------------------------------------------
;Wv
[State -1]
type = varset
trigger1 = command = "holddown"
trigger1 = time > 5
trigger1 = statetype != A && ctrl
var(7) = 1

[State -1]
type = varset
trigger1 = command = "DU"
trigger1 = statetype = S && ctrl
var(6) = 1

[State -1]
type = ChangeState
trigger1 = command = "DU"
trigger1 = statetype = S && ctrl
value = 40

;Kung Fu Throw
;
[State -1]
type = ChangeState
value = 900
triggerall = command = "z"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 8
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H

[State -1]
type = ChangeState
value = 901
triggerall = command = "z"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdback"
trigger1 = p2bodydist X < 10
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
;========================================================================
;------------------------------------------------------------------------
;ip`
[State -1]
type = ChangeState
value = 230
triggerall = var(3) = 1 && command = "x" && command = "holdf"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = [150,153])
trigger2 = p2stateno = var(21) || p2stateno = var(22) || p2stateno = var(23) || p2stateno = var(24) || p2stateno = var(25)
trigger3 = (stateno = [150,153])
trigger3 = p2stateno = var(26) || p2stateno = var(27) || p2stateno = var(28) || p2stateno = var(29) || p2stateno = var(30)
trigger4 = (stateno = [150,153])
trigger4 = p2stateno = var(31) || p2stateno = var(32) || p2stateno = var(33) || p2stateno = var(34) || p2stateno = var(35)
trigger5 = (stateno = [150,153])
trigger5 = p2stateno = var(36) || p2stateno = var(37) || p2stateno = var(38) || p2stateno = var(39) || p2stateno = var(40)
;------------------------------------------------------------------------
;Stand Light Punch
;p`
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = var(3) = 0 && command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;------------------------------------------------------------------------
;Stand Light Punch
;p`
[State -1, Stand Light Punch]
type = ChangeState
value = 205
triggerall = var(3) = 1 && command = "x"
triggerall = command != "holddown" && statetype = S
trigger1 = ctrl
trigger2 = (stateno = [150,153])
trigger2 = p2stateno = var(21) || p2stateno = var(22) || p2stateno = var(23) || p2stateno = var(24) || p2stateno = var(25)
trigger3 = (stateno = [150,153])
trigger3 = p2stateno = var(26) || p2stateno = var(27) || p2stateno = var(28) || p2stateno = var(29) || p2stateno = var(30)
trigger4 = (stateno = [150,153])
trigger4 = p2stateno = var(31) || p2stateno = var(32) || p2stateno = var(33) || p2stateno = var(34) || p2stateno = var(35)
trigger5 = (stateno = [150,153])
trigger5 = p2stateno = var(36) || p2stateno = var(37) || p2stateno = var(38) || p2stateno = var(39) || p2stateno = var(40)
trigger6 = numhelper(0) = 1 && stateno = [150,153]
;------------------------------------------------------------------------
;ip`
[State -1]
type = ChangeState
value = 240
triggerall = var(3) = 1 && command = "y" && command = "holdf"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = (stateno = [150,153])
trigger2 = p2stateno = var(21) || p2stateno = var(22) || p2stateno = var(23) || p2stateno = var(24) || p2stateno = var(25)
trigger3 = (stateno = [150,153])
trigger3 = p2stateno = var(26) || p2stateno = var(27) || p2stateno = var(28) || p2stateno = var(29) || p2stateno = var(30)
trigger4 = (stateno = [150,153])
trigger4 = p2stateno = var(31) || p2stateno = var(32) || p2stateno = var(33) || p2stateno = var(34) || p2stateno = var(35)
trigger5 = (stateno = [150,153])
trigger5 = p2stateno = var(36) || p2stateno = var(37) || p2stateno = var(38) || p2stateno = var(39) || p2stateno = var(40)
trigger6 = numhelper(0) = 1 && stateno = [150,153]
;------------------------------------------------------------------------
;Stand Strong Punch
;p`
[State -1]
type = ChangeState
value = 210
triggerall = var(3) = 0 && command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;------------------------------------------------------------------------
;Stand Strong Punch
;p`
[State -1]
type = ChangeState
value = 215
triggerall = var(3) = 1
triggerall = command = "y" && command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = (stateno = [150,153])
trigger2 = p2stateno = var(21) || p2stateno = var(22) || p2stateno = var(23) || p2stateno = var(24) || p2stateno = var(25)
trigger3 = (stateno = [150,153])
trigger3 = p2stateno = var(26) || p2stateno = var(27) || p2stateno = var(28) || p2stateno = var(29) || p2stateno = var(30)
trigger4 = (stateno = [150,153])
trigger4 = p2stateno = var(31) || p2stateno = var(32) || p2stateno = var(33) || p2stateno = var(34) || p2stateno = var(35)
trigger5 = (stateno = [150,153])
trigger5 = p2stateno = var(36) || p2stateno = var(37) || p2stateno = var(38) || p2stateno = var(39) || p2stateno = var(40)
trigger6 = numhelper(0) = 1 && stateno = [150,153]
;------------------------------------------------------------------------
;Stand Light Kick
;LbN
[State -1, Stand Light Kick]
type = ChangeState
value = 222
triggerall = var(3) = 0 && command = "z"
triggerall = command = "holdf"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Light Kick]
type = ChangeState
value = 220
triggerall = var(3) = 0 && command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
;------------------------------------------------------------------------
;Stand Light Kick
;LbN
[State -1, Stand Light Kick]
type = ChangeState
value = 225
triggerall = var(3) = 1 && command = "z"
triggerall = command != "holddown" && statetype = S
trigger1 = ctrl
trigger2 = (stateno = [150,153])
trigger2 = p2stateno = var(21) || p2stateno = var(22) || p2stateno = var(23) || p2stateno = var(24) || p2stateno = var(25)
trigger3 = (stateno = [150,153])
trigger3 = p2stateno = var(26) || p2stateno = var(27) || p2stateno = var(28) || p2stateno = var(29) || p2stateno = var(30)
trigger4 = (stateno = [150,153])
trigger4 = p2stateno = var(31) || p2stateno = var(32) || p2stateno = var(33) || p2stateno = var(34) || p2stateno = var(35)
trigger5 = (stateno = [150,153])
trigger5 = p2stateno = var(36) || p2stateno = var(37) || p2stateno = var(38) || p2stateno = var(39) || p2stateno = var(40)
trigger6 = numhelper(0) = 1 && stateno = [150,153]
;------------------------------------------------------------------------
;Stand On
[State -1]
type = ChangeState
value = 113
triggerall = statetype = C && command = "holddown"
triggerall = ctrl && var(3) = 0
trigger1 =  command = "a" || command = "ax" || command = "ay" || command = "az"

[State -1]
type = ChangeState
value = 114
triggerall = statetype = C && command = "holddown"
triggerall = ctrl && var(3) = 1
trigger1 =  command = "a"

;------------------------------------------------------------------------
;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = var(3) = 0 && command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;------------------------------------------------------------------------
;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 405
triggerall = var(3) = 1 && command = "x"
triggerall = command = "holddown" && statetype = C
trigger1 = ctrl
trigger2 = (stateno = [150,153])
trigger2 = p2stateno = var(21) || p2stateno = var(22) || p2stateno = var(23) || p2stateno = var(24) || p2stateno = var(25)
trigger3 = (stateno = [150,153])
trigger3 = p2stateno = var(26) || p2stateno = var(27) || p2stateno = var(28) || p2stateno = var(29) || p2stateno = var(30)
trigger4 = (stateno = [150,153])
trigger4 = p2stateno = var(31) || p2stateno = var(32) || p2stateno = var(33) || p2stateno = var(34) || p2stateno = var(35)
trigger5 = (stateno = [150,153])
trigger5 = p2stateno = var(36) || p2stateno = var(37) || p2stateno = var(38) || p2stateno = var(39) || p2stateno = var(40)
trigger6 = numhelper(0) = 1 && stateno = [150,153]
;------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = var(3) = 0 && command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 415
triggerall = var(3) = 1 && command = "y"
triggerall = command = "holddown" && statetype = C
trigger1 = ctrl
trigger2 = (stateno = [150,153])
trigger2 = p2stateno = var(21) || p2stateno = var(22) || p2stateno = var(23) || p2stateno = var(24) || p2stateno = var(25)
trigger3 = (stateno = [150,153])
trigger3 = p2stateno = var(26) || p2stateno = var(27) || p2stateno = var(28) || p2stateno = var(29) || p2stateno = var(30)
trigger4 = (stateno = [150,153])
trigger4 = p2stateno = var(31) || p2stateno = var(32) || p2stateno = var(33) || p2stateno = var(34) || p2stateno = var(35)
trigger5 = (stateno = [150,153])
trigger5 = p2stateno = var(36) || p2stateno = var(37) || p2stateno = var(38) || p2stateno = var(39) || p2stateno = var(40)
trigger6 = numhelper(0) = 1 && stateno = [150,153]
;------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݃p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 420
triggerall = var(3) = 0
triggerall = command = "z" && command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݃p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 425
triggerall = var(3) = 1 && statetype = C
triggerall = command = "z" && command = "holddown"
trigger1 = ctrl
trigger2 = (stateno = [150,153])
trigger2 = p2stateno = var(21) || p2stateno = var(22) || p2stateno = var(23) || p2stateno = var(24) || p2stateno = var(25)
trigger3 = (stateno = [150,153])
trigger3 = p2stateno = var(26) || p2stateno = var(27) || p2stateno = var(28) || p2stateno = var(29) || p2stateno = var(30)
trigger4 = (stateno = [150,153])
trigger4 = p2stateno = var(31) || p2stateno = var(32) || p2stateno = var(33) || p2stateno = var(34) || p2stateno = var(35)
trigger5 = (stateno = [150,153])
trigger5 = p2stateno = var(36) || p2stateno = var(37) || p2stateno = var(38) || p2stateno = var(39) || p2stateno = var(40)
trigger6 = numhelper(0) = 1 && stateno = [150,153]
;------------------------------------------------------------------------
;Jump Light Punch
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x" && var(3) = 0 && statetype = A
trigger1 = ctrl
trigger2 = stateno = 116
;------------------------------------------------------------------------
;Jump Light Punch
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 605
triggerall = command = "x" && var(3) = 1 && statetype = A
trigger1 = ctrl
trigger2 = stateno = 115
;------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y" && var(3) = 0 && statetype = A
trigger1 = ctrl
trigger2 = stateno = 116
;------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 615
triggerall = command = "y" && var(3) = 1 && statetype = A
trigger1 = ctrl
trigger2 = stateno = 115
;------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 620
triggerall = command = "z" && var(3) = 0 && statetype = A
trigger1 = ctrl
trigger2 = stateno = 116
;------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 625
triggerall = command = "z" && var(3) = 1 && statetype = A
trigger1 = ctrl
trigger2 = stateno = 115
;------------------------------------------------------------------------
;Jump Stand On
[State -1, Stand On]
type = ChangeState
value = 115+(var(3) = 1)
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
